﻿/*
Copyright (c) 2010 Mathias Möhl
All rights reserved.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
OTHER DEALINGS IN THE SOFTWARE.
*/ 

// Version history
// 1.0 initial release
// 2.0 added local mode
// 2.1 - allowed to modify more than one property in local mode simultaneously (if prop is not a mask)
//        - made global mode work with 1d-properties
//        - images are embedded now in script source
{
var KeyTweakBasicGlobals = new Object();  // store all global variables here
KeyTweakBasicGlobals.scriptName = "KeyTweak";
KeyTweakBasicGlobals.scriptVersionNumber="2.1";
KeyTweakBasicGlobals.scriptVersion = "Version "+KeyTweakBasicGlobals.scriptVersionNumber;
KeyTweakBasicGlobals.scriptURLName="keytweak";// the name used for update checks

KeyTweakBasicGlobals.settingsSection = "KeyTweak - Settings";
KeyTweakBasicGlobals.language = app.settings.haveSetting(KeyTweakBasicGlobals.settingsSection,"language") ?
	(app.settings.getSetting(KeyTweakBasicGlobals.settingsSection,"language")):("auto");
	
KeyTweakBasicGlobals.progressBarEnabled = (parseFloat(app.version) >= 9.0);  // enable progress bar only for AE CS4 and higher.
KeyTweakBasicGlobals.onlyWorkarea=true; // limit to workarea by default

KeyTweakBasicGlobals.myPrefFolder=Folder.userData.fsName + "/Aescripts/KeyTweak/";
// create the folder if it does not exist yet
createFolderIfNotExisting(Folder.userData.fsName + "/Aescripts");
createFolderIfNotExisting(KeyTweakBasicGlobals.myPrefFolder);
// create logo image, if it deos not exist yet
KeyTweakBasicGlobals.logoString='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';
KeyTweakBasicGlobals.logoFile=getIcon (File(KeyTweakBasicGlobals.myPrefFolder+"keytweak_logo.png"),KeyTweakBasicGlobals.logoString);

KeyTweakBasicGlobals.imageModeWorkareaFadeString='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';
KeyTweakBasicGlobals.imageModeWorkareaFadeFile=getIcon (File(KeyTweakBasicGlobals.myPrefFolder+"keytweak_option_linear.png"),KeyTweakBasicGlobals.imageModeWorkareaFadeString);
KeyTweakBasicGlobals.imageModeWorkareaFadeInString='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';
KeyTweakBasicGlobals.imageModeWorkareaFadeInFile=getIcon (File(KeyTweakBasicGlobals.myPrefFolder+"keytweak_option_fade_in.png"),KeyTweakBasicGlobals.imageModeWorkareaFadeInString);
KeyTweakBasicGlobals.imageModeWorkareaFadeOutString='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';
KeyTweakBasicGlobals.imageModeWorkareaFadeOutFile=getIcon (File(KeyTweakBasicGlobals.myPrefFolder+"keytweak_option_fade_out.png"),KeyTweakBasicGlobals.imageModeWorkareaFadeOutString);
KeyTweakBasicGlobals.imageModeWorkareaConstantString='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';
KeyTweakBasicGlobals.imageModeWorkareaConstantFile=getIcon (File(KeyTweakBasicGlobals.myPrefFolder+"keytweak_option_constant.png"),KeyTweakBasicGlobals.imageModeWorkareaConstantString);
KeyTweakBasicGlobals.imageModeOnlyCurrentFrameString='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';
KeyTweakBasicGlobals.imageModeOnlyCurrentFrameFile=getIcon (File(KeyTweakBasicGlobals.myPrefFolder+"keytweak_option_currentframe.png"),KeyTweakBasicGlobals.imageModeOnlyCurrentFrameString);

KeyTweakBasicGlobals.imageArrowUpString='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';
KeyTweakBasicGlobals.imageArrowUpFile=getIcon (File(KeyTweakBasicGlobals.myPrefFolder+"keytweak_arrow_up.png"),KeyTweakBasicGlobals.imageArrowUpString);
KeyTweakBasicGlobals.imageArrowDownString='iVBORw0KGgoAAAANSUhEUgAAABUAAAAVCAIAAAAmdTLBAAAACXBIWXMAAAsTAAALEwEAmpwYAAAKT2lDQ1BQaG90b3Nob3AgSUNDIHByb2ZpbGUAAHjanVNnVFPpFj333vRCS4iAlEtvUhUIIFJCi4AUkSYqIQkQSoghodkVUcERRUUEG8igiAOOjoCMFVEsDIoK2AfkIaKOg6OIisr74Xuja9a89+bN/rXXPues852zzwfACAyWSDNRNYAMqUIeEeCDx8TG4eQuQIEKJHAAEAizZCFz/SMBAPh+PDwrIsAHvgABeNMLCADATZvAMByH/w/qQplcAYCEAcB0kThLCIAUAEB6jkKmAEBGAYCdmCZTAKAEAGDLY2LjAFAtAGAnf+bTAICd+Jl7AQBblCEVAaCRACATZYhEAGg7AKzPVopFAFgwABRmS8Q5ANgtADBJV2ZIALC3AMDOEAuyAAgMADBRiIUpAAR7AGDIIyN4AISZABRG8lc88SuuEOcqAAB4mbI8uSQ5RYFbCC1xB1dXLh4ozkkXKxQ2YQJhmkAuwnmZGTKBNA/g88wAAKCRFRHgg/P9eM4Ors7ONo62Dl8t6r8G/yJiYuP+5c+rcEAAAOF0ftH+LC+zGoA7BoBt/qIl7gRoXgugdfeLZrIPQLUAoOnaV/Nw+H48PEWhkLnZ2eXk5NhKxEJbYcpXff5nwl/AV/1s+X48/Pf14L7iJIEyXYFHBPjgwsz0TKUcz5IJhGLc5o9H/LcL//wd0yLESWK5WCoU41EScY5EmozzMqUiiUKSKcUl0v9k4t8s+wM+3zUAsGo+AXuRLahdYwP2SycQWHTA4vcAAPK7b8HUKAgDgGiD4c93/+8//UegJQCAZkmScQAAXkQkLlTKsz/HCAAARKCBKrBBG/TBGCzABhzBBdzBC/xgNoRCJMTCQhBCCmSAHHJgKayCQiiGzbAdKmAv1EAdNMBRaIaTcA4uwlW4Dj1wD/phCJ7BKLyBCQRByAgTYSHaiAFiilgjjggXmYX4IcFIBBKLJCDJiBRRIkuRNUgxUopUIFVIHfI9cgI5h1xGupE7yAAygvyGvEcxlIGyUT3UDLVDuag3GoRGogvQZHQxmo8WoJvQcrQaPYw2oefQq2gP2o8+Q8cwwOgYBzPEbDAuxsNCsTgsCZNjy7EirAyrxhqwVqwDu4n1Y8+xdwQSgUXACTYEd0IgYR5BSFhMWE7YSKggHCQ0EdoJNwkDhFHCJyKTqEu0JroR+cQYYjIxh1hILCPWEo8TLxB7iEPENyQSiUMyJ7mQAkmxpFTSEtJG0m5SI+ksqZs0SBojk8naZGuyBzmULCAryIXkneTD5DPkG+Qh8lsKnWJAcaT4U+IoUspqShnlEOU05QZlmDJBVaOaUt2ooVQRNY9aQq2htlKvUYeoEzR1mjnNgxZJS6WtopXTGmgXaPdpr+h0uhHdlR5Ol9BX0svpR+iX6AP0dwwNhhWDx4hnKBmbGAcYZxl3GK+YTKYZ04sZx1QwNzHrmOeZD5lvVVgqtip8FZHKCpVKlSaVGyovVKmqpqreqgtV81XLVI+pXlN9rkZVM1PjqQnUlqtVqp1Q61MbU2epO6iHqmeob1Q/pH5Z/YkGWcNMw09DpFGgsV/jvMYgC2MZs3gsIWsNq4Z1gTXEJrHN2Xx2KruY/R27iz2qqaE5QzNKM1ezUvOUZj8H45hx+Jx0TgnnKKeX836K3hTvKeIpG6Y0TLkxZVxrqpaXllirSKtRq0frvTau7aedpr1Fu1n7gQ5Bx0onXCdHZ4/OBZ3nU9lT3acKpxZNPTr1ri6qa6UbobtEd79up+6Ynr5egJ5Mb6feeb3n+hx9L/1U/W36p/VHDFgGswwkBtsMzhg8xTVxbzwdL8fb8VFDXcNAQ6VhlWGX4YSRudE8o9VGjUYPjGnGXOMk423GbcajJgYmISZLTepN7ppSTbmmKaY7TDtMx83MzaLN1pk1mz0x1zLnm+eb15vft2BaeFostqi2uGVJsuRaplnutrxuhVo5WaVYVVpds0atna0l1rutu6cRp7lOk06rntZnw7Dxtsm2qbcZsOXYBtuutm22fWFnYhdnt8Wuw+6TvZN9un2N/T0HDYfZDqsdWh1+c7RyFDpWOt6azpzuP33F9JbpL2dYzxDP2DPjthPLKcRpnVOb00dnF2e5c4PziIuJS4LLLpc+Lpsbxt3IveRKdPVxXeF60vWdm7Obwu2o26/uNu5p7ofcn8w0nymeWTNz0MPIQ+BR5dE/C5+VMGvfrH5PQ0+BZ7XnIy9jL5FXrdewt6V3qvdh7xc+9j5yn+M+4zw33jLeWV/MN8C3yLfLT8Nvnl+F30N/I/9k/3r/0QCngCUBZwOJgUGBWwL7+Hp8Ib+OPzrbZfay2e1BjKC5QRVBj4KtguXBrSFoyOyQrSH355jOkc5pDoVQfujW0Adh5mGLw34MJ4WHhVeGP45wiFga0TGXNXfR3ENz30T6RJZE3ptnMU85ry1KNSo+qi5qPNo3ujS6P8YuZlnM1VidWElsSxw5LiquNm5svt/87fOH4p3iC+N7F5gvyF1weaHOwvSFpxapLhIsOpZATIhOOJTwQRAqqBaMJfITdyWOCnnCHcJnIi/RNtGI2ENcKh5O8kgqTXqS7JG8NXkkxTOlLOW5hCepkLxMDUzdmzqeFpp2IG0yPTq9MYOSkZBxQqohTZO2Z+pn5mZ2y6xlhbL+xW6Lty8elQfJa7OQrAVZLQq2QqboVFoo1yoHsmdlV2a/zYnKOZarnivN7cyzytuQN5zvn//tEsIS4ZK2pYZLVy0dWOa9rGo5sjxxedsK4xUFK4ZWBqw8uIq2Km3VT6vtV5eufr0mek1rgV7ByoLBtQFr6wtVCuWFfevc1+1dT1gvWd+1YfqGnRs+FYmKrhTbF5cVf9go3HjlG4dvyr+Z3JS0qavEuWTPZtJm6ebeLZ5bDpaql+aXDm4N2dq0Dd9WtO319kXbL5fNKNu7g7ZDuaO/PLi8ZafJzs07P1SkVPRU+lQ27tLdtWHX+G7R7ht7vPY07NXbW7z3/T7JvttVAVVN1WbVZftJ+7P3P66Jqun4lvttXa1ObXHtxwPSA/0HIw6217nU1R3SPVRSj9Yr60cOxx++/p3vdy0NNg1VjZzG4iNwRHnk6fcJ3/ceDTradox7rOEH0x92HWcdL2pCmvKaRptTmvtbYlu6T8w+0dbq3nr8R9sfD5w0PFl5SvNUyWna6YLTk2fyz4ydlZ19fi753GDborZ752PO32oPb++6EHTh0kX/i+c7vDvOXPK4dPKy2+UTV7hXmq86X23qdOo8/pPTT8e7nLuarrlca7nuer21e2b36RueN87d9L158Rb/1tWeOT3dvfN6b/fF9/XfFt1+cif9zsu72Xcn7q28T7xf9EDtQdlD3YfVP1v+3Njv3H9qwHeg89HcR/cGhYPP/pH1jw9DBY+Zj8uGDYbrnjg+OTniP3L96fynQ89kzyaeF/6i/suuFxYvfvjV69fO0ZjRoZfyl5O/bXyl/erA6xmv28bCxh6+yXgzMV70VvvtwXfcdx3vo98PT+R8IH8o/2j5sfVT0Kf7kxmTk/8EA5jz/GMzLdsAAAAgY0hSTQAAeiUAAICDAAD5/wAAgOkAAHUwAADqYAAAOpgAABdvkl/FRgAAAiBJREFUeNqEUkFLG0EU/mayuTQx5lDTTc0tUPwBlXquh0BbilSQJnhQf0HxbxS8FPGq4FlKwWK92UMP1murl1iwFALWZJ3dg01m3uthsptxN7Ufj4GZ731vvvd40FprPcjGYNBfXV0plUonJ1/HJtiQRIbGod1ub2/vKKXa7Tb9E8YjMgAAZmaAAQBSCBEEATMDEALGDFwKDjwiI4RgJiKKORZCVqt+qTShVKj1wBjtUq5espUSDT0wMxNAxeK9YnECQKfTSVFueLFz2BOAlMMf7MvNzZ8sNfJvywKwDu3JzEScVHEoEZeCnYh0xa6LZEwuJYR9H06aiDyb4Tq0AimldZsYTMwnFYm07T9t3mbn88PqFq67od4YTwiZ/HBrMJ5XKBQA5PP5LBt3RKP5GWOCINjbe9/v93O5HIBerwfg6OizvV5c/JyZedRsvh41Ij1EUaBUV6krpa7W1lbwPxwefgzDbhh2o6gXhl0ZdycBMTf35G6x7/v1el3KnJQ5IaSUOelOvtVqLiy8vEO/vv7G9/1bT0p1w7CXxNnZt0qlMla8vNyKoiAVkh1oraenH+7vf6hW/ZR4cfHV1tYmZyCur3+ntgLAwcGnpaWW0/aD4+Mv5XI5ayr5H/EJZjQajfn5pzZjaur+7u7O5GQ5YZ1gGS9zekM2N9/VajUAGxtvZ2cfj18fZnF5+UsAgMjy309Pz89/vHj+bPzygcnovwMAjqrehO25HbMAAAAASUVORK5CYII=';
KeyTweakBasicGlobals.imageArrowDownFile=getIcon (File(KeyTweakBasicGlobals.myPrefFolder+"keytweak_arrow_down.png"),KeyTweakBasicGlobals.imageArrowDownString);
KeyTweakBasicGlobals.imageArrowLeftString='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';
KeyTweakBasicGlobals.imageArrowLeftFile=getIcon (File(KeyTweakBasicGlobals.myPrefFolder+"keytweak_arrow_left.png"),KeyTweakBasicGlobals.imageArrowLeftString);
KeyTweakBasicGlobals.imageArrowRightString='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';
KeyTweakBasicGlobals.imageArrowRightFile=getIcon (File(KeyTweakBasicGlobals.myPrefFolder+"keytweak_arrow_right.png"),KeyTweakBasicGlobals.imageArrowRightString);
KeyTweakBasicGlobals.imageArrowULString='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';
KeyTweakBasicGlobals.imageArrowULFile=getIcon (File(KeyTweakBasicGlobals.myPrefFolder+"keytweak_arrow_ul.png"),KeyTweakBasicGlobals.imageArrowULString);
KeyTweakBasicGlobals.imageArrowURString='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';
KeyTweakBasicGlobals.imageArrowURFile=getIcon (File(KeyTweakBasicGlobals.myPrefFolder+"keytweak_arrow_ur.png"),KeyTweakBasicGlobals.imageArrowURString);
KeyTweakBasicGlobals.imageArrowDLString='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';
KeyTweakBasicGlobals.imageArrowDLFile=getIcon (File(KeyTweakBasicGlobals.myPrefFolder+"keytweak_arrow_dl.png"),KeyTweakBasicGlobals.imageArrowDLString);
KeyTweakBasicGlobals.imageArrowDRString='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';
KeyTweakBasicGlobals.imageArrowDRFile=getIcon (File(KeyTweakBasicGlobals.myPrefFolder+"keytweak_arrow_dr.png"),KeyTweakBasicGlobals.imageArrowDRString);

KeyTweakBasicGlobals.ModeWorkareaFade=1;
KeyTweakBasicGlobals.ModeWorkareaConstant=2;
KeyTweakBasicGlobals.ModeCurrentFrame=3;
KeyTweakBasicGlobals.ModeWorkareaFadeIn=4;
KeyTweakBasicGlobals.ModeWorkareaFadeOut=5;
KeyTweakBasicGlobals.MaskVertexFirst=0; // for masks, only vertices between first and last are modified
KeyTweakBasicGlobals.MaskVertexNum=1; // number of selected vertices
KeyTweakBasicGlobals.selectedMode = KeyTweakBasicGlobals.ModeWorkareaFade;
KeyTweakBasicGlobals.visualizationLayerName="KeyTweak - Visualization";
KeyTweakBasicGlobals.circleEffectNamePrefix ="VizPoint-";
KeyTweakBasicGlobals.circleEffectColor=[0.9,0.2,0.2];
KeyTweakBasicGlobals.circleEffectTransparency = 80;
KeyTweakBasicGlobals.circleEffectRadius=10;
KeyTweakBasicGlobals.circleEffectRadiusScaleFirst=1.5;        // the first point has a radius that is scaled by X
KeyTweakBasicGlobals.circleEffectRadiusSpacingFactor=0.4;  // the radius of the circle is at most X times the minimum distance between two of the points

KeyTweakBasicGlobals.stepSize1= app.settings.haveSetting(KeyTweakBasicGlobals.settingsSection, 'stepSize1')?
	app.settings.getSetting(KeyTweakBasicGlobals.settingsSection, 'stepSize1')
	: ('0.5');
KeyTweakBasicGlobals.stepSize2=app.settings.haveSetting(KeyTweakBasicGlobals.settingsSection, 'stepSize2')?
	app.settings.getSetting(KeyTweakBasicGlobals.settingsSection, 'stepSize2')
	: ('10');
KeyTweakBasicGlobals.onlineUpdate = app.settings.haveSetting(KeyTweakBasicGlobals.settingsSection,"onlineUpdate") ?
	(app.settings.getSetting(KeyTweakBasicGlobals.settingsSection,"onlineUpdate")=="true"):true;
if(KeyTweakBasicGlobals.onlineUpdate){checkUpdates(true);};


//////////////////////////////////////////////////////////////////////////////////////////////////////////  EULA start
KeyTweakBasicGlobals.eulaEn =
"THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, "+
"INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR "+
"PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE "+
"LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT "+
"OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR "+
"OTHER DEALINGS IN THE SOFTWARE.";
KeyTweakBasicGlobals.eulaDe =
"DIE SOFTWARE WIRD OHNE JEDE AUSDRÜCKLICHE ODER IMPLIZIERTE GARANTIE BEREITGESTELLT, "+
"EINSCHLIESSLICH DER GARANTIE ZUR BENUTZUNG FÜR DEN VORGESEHENEN ODER EINEM BESTIMMTEN "+
"ZWECK SOWIE JEGLICHER RECHTSVERLETZUNG, JEDOCH NICHT DARAUF BESCHRÄNKT. IN KEINEM FALL "+
"SIND DIE AUTOREN ODER COPYRIGHTINHABER FÜR JEGLICHEN SCHADEN ODER SONSTIGE ANSPRÜCHE "+
"HAFTBAR ZU MACHEN, OB INFOLGE DER ERFÜLLUNG EINES VERTRAGES, EINES DELIKTES ODER ANDERS "+
"IM ZUSAMMENHANG MIT DER SOFTWARE ODER SONSTIGER VERWENDUNG DER SOFTWARE ENTSTANDEN.";
KeyTweakBasicGlobals.eula=loc({en:KeyTweakBasicGlobals.eulaEn,de:KeyTweakBasicGlobals.eulaDe})
//////////////////////////////////////////////////////////////////////////////////////////////////////// EULA end

KeyTweakBasicGlobals.helpTextEn=
KeyTweakBasicGlobals.scriptName+ " "+ KeyTweakBasicGlobals.scriptVersion +
' by mamoworld.com (c) 2010\n'+
'\n'+
'Video tutorial explaining the use of KeyTweak can be found on www.mamoworld.com\n'+
'\n'+
'KeyTweak allows you to modify a property with many keyframes (as for example a rotoscoping mask, a drifting trackpoint, a motion sketch path, or audio keyframes) an various clever ways. There are two very different functions: local and global mode. You can switch between them via the button at the bottom of the interface.\n'+
'\n'+
'#########################################\n'+
'LOCAL MODE\n'+
'#########################################\n'+
'\n'+
'In the local mode you can modify all keyframes of the selected property that are contained in the current workarea by clicking on any of  the arrow buttons. The numbers in the middle of the arrow buttons indicate, how much the values are changed. By default, the first group of arrows moves the keyframes by 0.5 pixels and the second group by 10 pixels, but you can adjust those values as you like. KeyTweak offers two groups of arrows such that you can use one for larger changes and one for fine tuning. \n'+
'\n'+
'How exactly the keyframes in the workarea are changed depends on the option you have chosen:\n'+
'\n'+
'workarea constant:\n'+
'with this option, all keyframes in the workarea are moved by the full amount.\n'+
'\n'+
'workarea fade in/out:\n'+
'Modifies only the keyframe at the current point in time by the full amount and all other keyframes in the workarea less, depending on how far away they are from the current time. This makes your changes fade in and out smoothly over time.\n'+
'\n'+
'workarea fade in:\n'+
'Modifies the keyframe at the current time and all keyframes behind it (in the workarea) by the full amount. Before the current time the keyframes are modified less such that the changes fade in smoothly over time.\n'+
'\n'+
'workarea fade out:\n'+
'Modifies the keyframe at the current time and all keyframes before it (in the workarea) by the fill amount. After the current time the keyframes are modified less such that your changes fade out smoothly over time.\n'+
'\n'+
'only current frame:\n'+
'Modifies only the keyframe at the current time and leaves all other keyframes untouched.\n'+
'\n'+
'Modifying masks and shapes:\n'+
'If you want to to tweak the keyframes of a mask or shape, you need to specify which shape vertices you want to modify by clicking on the button "select mask/shape vertices". In the window that pops up, you can choose the vertices you want to modify using the sliders. While the window is open, you see the selected vertices in the composition highlighted by red circles. \n'+
'\n'+
'Note: The local mode only works with 2D properties (like layer positions or trackpoints or mask shapes) but not with 1D or 3D values (as sound keyframes or 3d positions).\n'+
'\n'+
'#########################################\n'+
'GLOBAL MODE\n'+
'#########################################\n'+
'\n'+
'The global mode offers the functionality of the earlier versions of KeyTweak. The idea is that you make a duplicate of your property, modify some keyframes in the duplicate by hand and delete the keyframes that should be modified accordingly by KeyTweak. It works in the following steps:\n'+
'step 1: make a duplicate of the property whose keys you want to tweak (i.e. duplicate the property/tracker/layer/... which the property lives in)\n'+
'step 2: remove in the duplicate all keyframes that you want the script to tweak for you\n'+
'step 3: tweak the remaining keyframes by hand\n'+
'step 4: select the original property and its duplicate (no matter in which order) and hit the KeyTweak button\n';
 
 
 
KeyTweakBasicGlobals.helpTextDe=
KeyTweakBasicGlobals.scriptName+ " "+ KeyTweakBasicGlobals.scriptVersion +
' by mamoworld.com (c) 2010\n'+
'\n'+
 'Videotutorials, die dir erklären wie Du KeyTweak benutzt, findest Du auf www.mamoworld.com\n\n'+
'Mit KeyTweak kannst du Eigenschaften mit vielen Keyframes (wie etwa Rotoscoping-Masken, driftende Tracks, Motion-Sketch-Pfade oder Audio-Keyframes) auf verschiedene Weise verändern. KeyTweak bietet grundsätzlich zwei verschiedene Arbeitsmodi: den lokalen Modus und den globalen Modus. Du kannst zwischen den beiden Modi über den Button am unteren Rand der Benutzeroberfläche hin- und herschalten.\n'+
'\n'+
'#########################################\n'+
'LOKALER MODUS\n'+
'#########################################\n'+
'\n'+
'Im lokalen Modus kannst Du mit Hilfe der Pfeil-Buttons alle Keyframes der ausgewählten Eigenschaft, die sich innerhalb des Arbeitsbereichs befinden, modifizieren. Die Zahl in der Mitte der Pfeil-Buttons gibt dabei an, um wieviel die Keyframes verändert werden sollen. KeyTweak bietet zwei Gruppen von Pfeilen, wobei die erste standardmäßig pro Klick um 0.5 Pixel verschiebt und die zweite um 10 Pixel. So kann man die eine Gruppe für das Feintuning und die andere für größere Verschiebungen nutzen. Die Werte lassen sich auch individuell anpassen.\n'+
'\n'+
'Wie genau die Keyframes im Arbeitsbereich verändert werden, hängt von der ausgewählten Option ab:\n'+
'\n'+
'Arbeitsbereich konstant:\n'+
'Verändert alle Keyframes im Arbeitsbereich auf die gleiche Weise um den vollen Betrag.\n'+
'\n'+
'Arbeitsbereich faden:\n'+
'Verändert nur den Keyframe am aktuellen Zeitpunkt um den vollen Betrag. Alle anderen Keyframes werden weniger verändert, so dass die Änderungen im zeitlichen Verlauf über den gesamten Arbeitsbereich Stück für Stück ein- und ausfaden.\n'+
'\n'+
'Arbeitsbereich einfaden:\n'+
'Verändert den Keyframe am aktuellen Zeitpunkt und alle Keyframes dahinter (innerhalb des Arbeitsbereichs) um den vollen Betrag. Vor dem aktuellen Zeitpunkt werden die Keyframes weniger modifiziert, so dass die Änderungen vom Beginn des Arbeitsbereichs an Stück für Stück einfaden.\n'+
'\n'+
'Arbeitsbereich ausfaden:\n'+
'Verändert den Keyframe am aktuellen Zeitpunkt und alle Keyframes davor (innerhalb des Arbeitsbereichs) um den vollen Betrag. Nach dem aktuellen Zeitpunkt bis zum Ende des Arbeitsbereichs werden die Keyframes weniger modifiziert, so dass die Änderungen bis zum Ende des Arbeitsbereichs Stück für Stück ausfaden.\n'+
'\n'+
'nur aktuellen Frame:\n'+
'Verändert nur den Keyframe am aktuellen Zeitpunkt. Alle anderen Keyframes werden nicht verändert.\n'+
'\n'+
'\n'+
'Masken und Shapes tweaken:\n'+
'Wenn Du Keyframes von Masken und Shapes tweaken willst, mußt Du KeyTweak angeben, welche Punkte der Maske bzw. Shape Du verschieben willst. Dazu klickst Du, nachdem du den Masken- bzw. Shape-Pfad angewählt hast, auf den Button "Masken-/Shape-Punkte auswählen" und wählst dann im erscheinenden Fenster mit Hilfe der Schieberegler die Punke aus. Solange das Fenster offen ist, werden die ausgewählten Punkte in der Komposition rot umrandet dargestellt.\n'+
'\n'+
'Hinweis:\n'+
'Der lokale Modus funktioniert nur mit 2D Eigenschaften(etwa Trackpunkten, Masken oder Ebenen-Positionen) aber nicht mit 1D- oder 3D-Eigenschaften (wie Audiokeyframes oder 3D-Ebenen).\n'+
'\n'+
'#########################################\n'+
'GLOBALER MODUS\n'+
'#########################################\n'+
'\n'+
'Der globale Modus entspricht der Funktionalität älterer Versionen von KeyTweak. Hier modifizierst Du die Keyframes an Hand einer Kopie Deiner Eigenschaft. In der Kopie modifizierst Du ein paar Keyframes von Hand, und löschst alle Keyframes, die von KeyTweak automatisch entsprechend ergänzt werden sollen.\n'+
'\n'+
'Die Schritte im einzelnen hierzu sind:\n'+
'Schritt 1: Mache ein Duplikate der gekeyframeten Eigenschaft (indem Du die entsprechende Ebene/Effekt/Maske/... duplizierst).\n'+
'Schritt 2: Entferne im Duplikat alle Keyframes, die KeyTweak automatisch tweaken soll.\n'+
'Schritt 3: Passe die übrigen Keyframes von Hand an.\n'+
'Schritt 4: Wähle die Original-Eigenschaft und das Duplikat (egal in welcher Reihenfolge) aus und klicke auf den KeyTweak-Button. \n';
 
KeyTweakBasicGlobals.helpText= loc({en:KeyTweakBasicGlobals.helpTextEn, de:KeyTweakBasicGlobals.helpTextDe});


// creates the folder whose path is given as argument in case the folder
// does not exist yet. It requires that the parent folder already exisits
function createFolderIfNotExisting(path){
if(! Folder(path).exists){
	var myFolder= new Folder(path);
	if(allowedToWriteFiles()){
		myFolder.create();
		if(myFolder.Error){
			myError(loc({en:'Could not create the following folder:',de:'Konnte den folgenden Ordner nicht erzeugen:'})+myFolder.absoluteURI+"\n"+
				myFolder.error);
			}
		}
	}
}

 /**
     Loads an icon file or recreate it if it does not exist
     @param {File} iconFile The file object to load
     @param {String} encodedStr The icon encoded as a base64 string
     @return {File} The loaded file or the new created file        
    */
    function getIcon (iconFile, encodedStr)
    {  // get this variable from "static variable" saved with this function
	   var warnedBefore=(typeof getIcon.warnedBefore=='undefined')?false:getIcon.warnedBefore;
        var retFile = iconFile;
		
        if (!retFile.exists) { 
            // recreate icon file
            //var binStr = hexToBin(hexStr);
            var binStr = base64Decode(encodedStr);
            retFile = new File(retFile.fsName);
            retFile.encoding = "BINARY";
            if(retFile.open("w")){
				retFile.write(binStr);
				retFile.close();
			     //myError("created file in "+retFile.absoluteURI);
				 }
			else {
				KeyTweakBasicGlobals.severeFail=true;
				if(!warnedBefore){
					getIcon.warnedBefore=true;
					myError(loc({en:'Could not create the following file:',de:'Konnte folgende Datei nicht erzeugen:'})+retFile.absoluteURI+"\n"+
					      loc({en:'Make sure that you have "Allow Scripts to Write Files and Access Network" enabled in your AE Preferences (Edit->Preferences->General).\n\nError Message:\n',
						  de:'Achte darauf, dass Du die Option "Skripten können Dateien schreiben und haben Netzwerkzugang" unter Bearbeiten->Voreinstellungen->Allgemein aktiviert hast.\n\nFehlermeldung:\n'})+
					    retFile.error
					  );
					  }
				}
        }        
        return retFile;    
    };


/**
 Converts base64 string to binary string
 @param {String} input A base64 encoded string to convert
 @return {String} A binary string
*/
function base64Decode(input){
	var output = "";
	var chr1, chr2, chr3;
	var enc1, enc2, enc3, enc4;
	var i = 0;
	
	input = input.replace(/[^A-Za-z0-9\+\/\=]/g, "");
	
	var key = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
	
	while(i<input.length){

		enc1 = key.indexOf(input.charAt(i++));
		enc2 = key.indexOf(input.charAt(i++));
		enc3 = key.indexOf(input.charAt(i++));
		enc4 = key.indexOf(input.charAt(i++));
		
		chr1 = (enc1 <<2)|(enc2 >> 4);
		chr2 = ((enc2 & 15) << 4)|(enc3>>2);
		chr3 = ((enc3 & 3) << 6) | enc4;
		
		output = output + String.fromCharCode(chr1);
		
		if(enc3 != 64){
			output = output + String.fromCharCode(chr2);
		}
		if (enc4 != 64) {
			output = output + String.fromCharCode(chr3);
		}
	}
	
	return output;
	
}

/**
	Returns true, if the AE prefs are set such that you can create files and access network
	an error message is printed to the user if the option to create files is disabled ONLY THE FIRST TIME THIS FUNCTION IS CALLED
**/
function allowedToWriteFiles(){
    // get this variable from "static variable" saved with this function
	var warnedBefore=(typeof allowedToWriteFiles.warnedBefore=='undefined')?false:allowedToWriteFiles.warnedBefore;
	
	var securitySetting = app.preferences.getPrefAsLong("Main Pref Section","Pref_SCRIPTING_FILE_NETWORK_SECURITY");
	var result =(securitySetting == 1);
	if(! result && (!warnedBefore)){
		allowedToWriteFiles.warnedBefore=true;
		myError(loc({en:'Some files for '+KeyTweakBasicGlobals.scriptName+
							   ' cannot be created.\nPlease enable "Allow Scripts to Write Files and Access Network" in your AE Preferences (Edit->Preferences->General).',
 				  	    de:'Einige Dateien für '+KeyTweakBasicGlobals.scriptName+
							   ' können nicht erzeugt werden.\nBitte aktiviere die Option "Skripten können Dateien schreiben und haben Netzwerkzugang" unter Bearbeiten->Voreinstellungen->Allgemein.'})
				   );
	   }
		
	return result;
	}



/****************************************************
Creates the user interface.
************************************************/ 
function buildUI(thisObj){
    // create window
    var pal = (thisObj instanceof Panel) ? thisObj : new Window("palette", KeyTweakBasicGlobals.scriptName,
								undefined,{resizeable: true});
    if (pal == null) return pal;
    
    // ------------------------------------------- define layout buttons
    var arrowHelpTip=loc({en:'moves the keyframes by the amount specified in the middle.',
								    de:'bewegt die Keyframes um den in der Mitte angegebenen Betrag.'});
	var arrowButtons=
		"Group{\
			orientation:'column', \
			alignment:['left','top'],\
			alignChildren:['fill','fill'],\
			margins:0,spacing:0,\
			helpTip:'test',\
			upper:Group{\
				alignment:['fill','fill'],\
				orientation:'row',spacing:0,\
				left:IconButton{icon:'"+KeyTweakBasicGlobals.imageArrowULFile.absoluteURI +"',alignment:['left','top'],helpTip:'"+arrowHelpTip+"'},\
				middle:IconButton{icon:'"+KeyTweakBasicGlobals.imageArrowUpFile.absoluteURI +"',alignment:['center','top'],helpTip:'"+arrowHelpTip+"'},\
				right:IconButton{icon:'"+KeyTweakBasicGlobals.imageArrowURFile.absoluteURI +"',alignment:['right','top'],helpTip:'"+arrowHelpTip+"'}\
			},\
			middle:Group{\
				alignment:['fill','fill'],\
				orientation:'row',spacing:0,\
				left:IconButton{icon:'"+KeyTweakBasicGlobals.imageArrowLeftFile.absoluteURI +"',alignment:['left','center'],helpTip:'"+arrowHelpTip+"'},\
			     step:EditText{text:'100',alignment:['center','center'],helpTip:'"+arrowHelpTip+"'},\
				 right:IconButton{icon:'"+KeyTweakBasicGlobals.imageArrowRightFile.absoluteURI +"',alignment:['right','center'],helpTip:'"+arrowHelpTip+"'}\
			},\
			lower:Group{\
				alignment:['fill','fill'],\
				orientation:'row',spacing:0,\
				left:IconButton{icon:'"+KeyTweakBasicGlobals.imageArrowDLFile.absoluteURI +"',alignment:['left','bottom'],helpTip:'"+arrowHelpTip+"'},\
				middle:IconButton{icon:'"+KeyTweakBasicGlobals.imageArrowDownFile.absoluteURI +"',alignment:['center','bottom'],helpTip:'"+arrowHelpTip+"'},\
				right:IconButton{icon:'"+KeyTweakBasicGlobals.imageArrowDRFile.absoluteURI +"',alignment:['right','bottom'],helpTip:'"+arrowHelpTip+"'}\
			}\
		}";
    
    var userInterface=
		"group{\
			orientation:'column', \
			margins:0,\
			logoBtn: " + 
			(KeyTweakBasicGlobals.logoFile.exists ? 
				("IconButton { icon:'" + KeyTweakBasicGlobals.logoFile.absoluteURI + "'}, "):  // use logo button if image file is present
				("Button {text: '"+loc({en:"Click here for Help (logo file missing)",de:"Hilfe (Logo Datei fehlt)"})+"'}, "))  // use normal button instead if image got lost...
			+ "\
			main:Group{\
				orientation:'stack', \
				margins:0,\
				alignment:['fill','fill'],\
				simple:Group{\
					orientation:'column', \
					alignment:['fill','fill'],\
					alignChildren:['fill','fill'],\
					margins:0,\
					crosses:Group{\
						alignment:['fill','top'],\
						orientation:'row',\
						cross1:"+arrowButtons+",\
						cross2:"+arrowButtons+",\
						helpBtn:Button{text:'?',preferredSize:[20,-1],alignment:['right','top'],\
						helpTip:'"+loc({en:'Click here for help and options.',
							                   de:'Hier findest Du die Hilfe und kannst Optionen einstellen.'}) +"'\
						}\
						},\
					buttons:Group{\
						spacing:2,\
						alignment:['fill','top'],\
						orientation:'row',\
						selecteMaskVectices:Button{text:'"+loc({en:'select mask/shape vertices',de:'Masken-/Shape-Punkte auswählen'})+"',\
						helpTip:'"+loc({en:'select which vertices of a mask/shape you modify.',
							                   de:'Wähle, welche Masken/Shape-Punkte Du verändern möchtest.'}) +"'\}\
						},\
					interpolation:Group{\
						alignment:['fill','top'],\
						orientation:'row', \
						method:Group{\
							orientation:'column', \
							alignChildren:['left','top'],\
							workareaConstant:RadioButton{text:'"+loc({en:'workarea constant',de:'Arbeitsbereich const.'})+"',\
							helpTip:'"+loc({en:'Modifies all keyframes in the workarea by the full amount.',
												 de:'Verändert alle Keyframes im Arbeitsbereich um den vollen Betrag.'}) +"'\},\
							workareaFade:RadioButton{text:'"+loc({en:'workarea fade in/out',de:'Arbeitsbereich faden'})+"',value:true,\
							helpTip:'"+loc({en:'Modifies only the keyframe at the current point in time by the full amount and fades this change in and out smoothly over the workarea.',
												 de:'Verändert nur den Keyframe am aktuellen Zeitpunkt um den vollen Betrag und faded diese Änderung über den gesamten Arbeitsbereich ein- und aus.'}) +"'\},\
							workareaFadeIn:RadioButton{text:'"+loc({en:'workarea fade in',de:'Arbeitsbereich einfaden'})+"',\
							helpTip:'"+loc({en:'Modifies the keyframe at the current time and all keyframes behind it (in the workarea) by the full amount. Before the current time the keyframes are faded in smoothly over time from the beginning of the work area.',
												 de:'Verändert den Keyframe am aktuellen Zeitpunkt und alle Keyframes dahinter (innerhalb des Arbeitsbereichs) um den vollen Betrag. Vor dem aktuellen Zeitpunkt werden die Keyframes vom Beginn des Arbeitsbereichs an eingefadet.'}) +"'\},\
							workareaFadeOut:RadioButton{text:'"+loc({en:'workarea fade out',de:'Arbeitsbreich ausfaden'})+"',\
							helpTip:'"+loc({en:'Modifies the keyframe at the current time and all keyframes before it (in the workarea) by the full amount. After the current time the change is fadedy out smoothly until the end of the workarea.',
							                        de:'Verändert den Keyframe am aktuellen Zeitpunkt und alle Keyframes davor (innerhalb des Arbeitsbereichs) um den vollen Betrag. Nach dem aktuellen Zeitpunkt bis zum Ende des Arbeitsbereichs werden die Änderungen ausgefadet.'}) +"'\},\
							onlyCurrentFrame:RadioButton{text:'"+loc({en:'only current frame',de:'nur aktuellen Frame'})+"',\
							helpTip:'"+loc({en:'Modifies only the keyframe at the current time and leaves all other keyframes untouched.',
												 de:'Verändert nur den Keyframe am aktuellen Zeitpunkt - alle anderen Keyframes werden nicht verändert.'}) +"'\}\
							},\
						viz:Image{icon:'"+KeyTweakBasicGlobals.imageModeWorkareaFadeFile.absoluteURI +"'}\
						},\
					changeMode:Group{\
						alignment:['fill','top'],\
						orientation:'row', \
						switchToAdvanced:Button{text:'"+loc({en:'switch to global mode',de:'zum globalen Modus wechseln'})+"'}\
						}\
					},\
				advanced:Group{\
				orientation:'column', \
					alignment:['fill','fill'],\
					alignChildren:['fill','top'],\
					margins:0,\
					apply:Group{\
						alignment:['fill','top'],\
						orientation:'row',spacing:2,\
						keyTweakBtn:Button{text:'KeyTweak',\
							helpTip:'"+loc({en:'select both your original property and the modified duplicate and click this button',
												 de:'wähle  Deine Original-Eigenschaft und die modifizierte Kopie aus und klicke auf diesen Button'}) +"'\
						},\
						helpBtn:Button{text:'?',preferredSize:[20,-1],alignment:['right','top']}\
						},\
					onlyWorkarea:Checkbox{text:'"+loc({en:'workarea only',de:'nur Arbeitsbereich'})+"',\
						helpTip:'"+loc({en:'modify only keyframes in the workarea',
											 de:'nur Keyframes im Arbeitsbereich modifizieren'})+"'},\
					writeOriginal:RadioButton{text:'"+loc({en:'overwrite original',de:'Original überschreiben'})+"',\
						helpTip:'"+loc({en:'KeyTweak modifies the keyframes of your original property',
									          de:'KeyTweak modifiziert die Keyframes der Original-Eigenschaft'})+"'},\
					writeModified:RadioButton{text:'"+loc({en:'fill duplicate',de:'Kopie ausfüllen'})+"',value:true,\
						helpTip:'"+loc({en:'KeyTweak modifies the keyframes of your duplicate',
											 de:'KeyTweak modifiziert die Keyframes der Kopie'})+"'}"
					+((KeyTweakBasicGlobals.progressBarEnabled)?",progressBar:Progressbar{value:0},":",")+
					"changeMode:Group{\
						alignment:['fill','top'],\
						orientation:'row', \
						switchToSimple:Button{text:'"+loc({en:'switch to local mode',de:'zum lokalen Modus wechseln'})+"'}\
						}\
					}\
				}\
			}";
	pal.margins=4;		
	pal.UI=pal.add(userInterface);
    
    pal.layout.layout(true);
    pal.layout.resize();
    pal.onResizing = pal.onResize = function () {
	this.layout.resize();
    }
    pal.UI.main.simple.visible=true;
	pal.UI.main.advanced.visible=false;
	
    pal.UI.main.simple.crosses.cross1.middle.step.text= KeyTweakBasicGlobals.stepSize1;
    pal.UI.main.simple.crosses.cross2.middle.step.text= KeyTweakBasicGlobals.stepSize2;
    
    KeyTweakBasicGlobals.writeOriginal=false;
    if(KeyTweakBasicGlobals.progressBarEnabled){  
	KeyTweakBasicGlobals.progress=pal.UI.main.advanced.progressBar;
	KeyTweakBasicGlobals.progress.value=0;
    }
    else { // create dummy progress bar that does nothing;
	KeyTweakBasicGlobals.progress = new Object(); 
	KeyTweakBasicGlobals.progress.value= 0;
	KeyTweakBasicGlobals.progress.maxvalue=100;	
    }	
    
    
    //-------------------------------------------  define behaviour of the buttons			
    pal.UI.main.advanced.apply.keyTweakBtn.onClick  = function(){
	app.beginUndoGroup("KeyTweak");
	keyTweak();
	app.endUndoGroup();			
    };
	//------------------------------  HELP WINDOW
	pal.UI.logoBtn.onClick=
	pal.UI.main.advanced.apply.helpBtn.onClick=
    pal.UI.main.simple.crosses.helpBtn.onClick  =  		
	pal.UI.logoBtn.onClick= function(){   
		var helpWindow= new Window("dialog", KeyTweakBasicGlobals.scriptName+" Help",undefined,  {resizeable: true} );
		var helpDlg = 
			"group{\
			orientation:'column', \
			alignment:['fill','fill'],\
			margins:0,\
			preferredSize:[400,400],\
			language:Group{\
				orientation:'row', \
				alignment:['left','top'],\
				languageText: StaticText{text:'"+loc({en:"User Interface Language",de:"Interface Sprache"})+"'},\
				langAuto: RadioButton{text:'auto', value:"+(KeyTweakBasicGlobals.language == "auto")+"},\
				langEn: RadioButton{text:'en', value:"+(KeyTweakBasicGlobals.language == "en")+"},\
				langDe: RadioButton{text:'de', value:"+(KeyTweakBasicGlobals.language == "de")+"}\
				},\
			update:Group{ alignment:['left','top']\
				onlineUpdateCheckBox:Checkbox{text:'"+loc({en:'Check for online updates every 10 days',de:'Prüfe alle 10 Tage auf Online-Updates'})+"', value:"+(KeyTweakBasicGlobals.onlineUpdate?("true"):("false"))+",alignment:['left','center']},\
				checkNow:Button{text:'"+loc({en:'Check now for updates',de:'Prüfe jetzt auf Updates'})+"',alignment:['left','center']}\
				},\
			helpbox:EditText{properties:{multiline:true, readonly:true},text:'',preferredSize:[-1,60],alignment:['fill','fill']},\
			okBtn:Button{text:'OK',alignment:['center','bottom']}\
			}";
		
		helpWindow.UI = helpWindow.add(helpDlg);
		helpWindow.UI.language.langAuto.onClick = function(){
			KeyTweakBasicGlobals.language = "auto";
			app.settings.saveSetting(KeyTweakBasicGlobals.settingsSection,"language",KeyTweakBasicGlobals.language);
			alert(loc({en:"The language change will take effect only after you restarted the script. To restart the script simply close the main window of the script interface and reopen it again.",
					                     de:"Die Änderung der Sprache wird erst wirksam, nachdem das Skript neu gestartet wurde. Dazu das Hauptfenster des Skriptes schließen und wieder neu öffnen."}),"Info");
			};
		helpWindow.UI.language.langEn.onClick = function(){
			KeyTweakBasicGlobals.language = "en";
			app.settings.saveSetting(KeyTweakBasicGlobals.settingsSection,"language",KeyTweakBasicGlobals.language);
			alert(loc({en:"The language change will take effect only after you restarted the script. To restart the script simply close the main window of the script interface and reopen it again.",
					                     de:"Die Änderung der Sprache wird erst wirksam, nachdem das Skript neu gestartet wurde. Dazu das Hauptfenster des Skriptes schließen und wieder neu öffnen."}),"Info");
			};
		helpWindow.UI.language.langDe.onClick = function(){
			KeyTweakBasicGlobals.language = "de";
			app.settings.saveSetting(KeyTweakBasicGlobals.settingsSection,"language",KeyTweakBasicGlobals.language);
			alert(loc({en:"The language change will take effect only after you restarted the script. To restart the script simply close the main window of the script interface and reopen it again.",
					                     de:"Die Änderung der Sprache wird erst wirksam, nachdem das Skript neu gestartet wurde. Dazu das Hauptfenster des Skriptes schließen und wieder neu öffnen."}),"Info");
			};
		helpWindow.UI.okBtn.onClick = function() {
			helpWindow.close(); 
			};
		helpWindow.UI.update.onlineUpdateCheckBox.onClick = function(){
			KeyTweakBasicGlobals.onlineUpdate=this.value;
			var storeVal=(KeyTweakBasicGlobals.onlineUpdate)?("true"):("false");  // encode as string
			app.settings.saveSetting(KeyTweakBasicGlobals.settingsSection,"onlineUpdate",storeVal);
			};
		helpWindow.UI.update.checkNow.onClick=function(){
			checkUpdates(false);
			};
		helpWindow.UI.helpbox.text=KeyTweakBasicGlobals.helpText;
		helpWindow.onResizing = helpWindow.onResize = function () {
			this.layout.resize();
			}
		helpWindow.show();
		};
    //------------------------------ END HELP WINDOW
    pal.UI.main.advanced.onlyWorkarea.onClick = function(){
	KeyTweakBasicGlobals.onlyWorkarea=pal.UI.main.advanced.onlyWorkarea.value;
    };
    pal.UI.main.advanced.writeOriginal.onClick = function(){
	KeyTweakBasicGlobals.writeOriginal=true;
    }
    pal.UI.main.advanced.writeModified.onClick = function(){
	KeyTweakBasicGlobals.writeOriginal=false;
			}
    pal.UI.main.simple.interpolation.method.workareaFade.onClick =function(){
	pal.UI.main.simple.interpolation.viz.image=KeyTweakBasicGlobals.imageModeWorkareaFadeFile;
	KeyTweakBasicGlobals.selectedMode = KeyTweakBasicGlobals.ModeWorkareaFade;
    };
	pal.UI.main.simple.interpolation.method.workareaFadeIn.onClick =function(){
	pal.UI.main.simple.interpolation.viz.image=KeyTweakBasicGlobals.imageModeWorkareaFadeInFile;
	KeyTweakBasicGlobals.selectedMode = KeyTweakBasicGlobals.ModeWorkareaFadeIn;
    };
  pal.UI.main.simple.interpolation.method.workareaFadeOut.onClick =function(){
	pal.UI.main.simple.interpolation.viz.image=KeyTweakBasicGlobals.imageModeWorkareaFadeOutFile;
	KeyTweakBasicGlobals.selectedMode = KeyTweakBasicGlobals.ModeWorkareaFadeOut;
    };
    pal.UI.main.simple.interpolation.method.workareaConstant.onClick =function(){
	pal.UI.main.simple.interpolation.viz.image=KeyTweakBasicGlobals.imageModeWorkareaConstantFile;
	KeyTweakBasicGlobals.selectedMode = KeyTweakBasicGlobals.ModeWorkareaConstant;
    };
    pal.UI.main.simple.interpolation.method.onlyCurrentFrame.onClick =function(){
	pal.UI.main.simple.interpolation.viz.image=KeyTweakBasicGlobals.imageModeOnlyCurrentFrameFile;
	KeyTweakBasicGlobals.selectedMode = KeyTweakBasicGlobals.ModeCurrentFrame;
    };
    
    pal.UI.main.simple.changeMode.switchToAdvanced.onClick=function(){pal.UI.main.simple.visible=false;pal.UI.main.advanced.visible=true;};
    pal.UI.main.advanced.changeMode.switchToSimple.onClick=function(){pal.UI.main.simple.visible=true;pal.UI.main.advanced.visible=false;};
    
    pal.UI.main.simple.crosses.cross1.middle.step.onChange = function(){
	KeyTweakBasicGlobals.stepSize1=this.text;
	app.settings.saveSetting(KeyTweakBasicGlobals.settingsSection, 'stepSize1',KeyTweakBasicGlobals.stepSize1)
    };
    pal.UI.main.simple.crosses.cross2.middle.step.onChange = function(){
	KeyTweakBasicGlobals.stepSize2=this.text;
	app.settings.saveSetting(KeyTweakBasicGlobals.settingsSection, 'stepSize2',KeyTweakBasicGlobals.stepSize2)
    };	
   
    /******************************** FIRST CROSS ********************************/
    pal.UI.main.simple.crosses.cross1.middle.left.onClick = function(){	
	app.beginUndoGroup("KeyTweak");
	keyMove([-1*KeyTweakBasicGlobals.stepSize1,0]);
	app.endUndoGroup();			
    };
    pal.UI.main.simple.crosses.cross1.middle.right.onClick = function(){
	app.beginUndoGroup("KeyTweak");
	keyMove([1*KeyTweakBasicGlobals.stepSize1,0]);
	app.endUndoGroup();			
    };
    pal.UI.main.simple.crosses.cross1.upper.left.onClick = function(){
	app.beginUndoGroup("KeyTweak");
	keyMove([-1*KeyTweakBasicGlobals.stepSize1,-1*KeyTweakBasicGlobals.stepSize1]);
	app.endUndoGroup();			
    };
    pal.UI.main.simple.crosses.cross1.upper.right.onClick = function(){
	app.beginUndoGroup("KeyTweak");
	keyMove([1*KeyTweakBasicGlobals.stepSize1,-1*KeyTweakBasicGlobals.stepSize1]);
	app.endUndoGroup();			
    };
    pal.UI.main.simple.crosses.cross1.lower.left.onClick = function(){
	app.beginUndoGroup("KeyTweak");
	keyMove([-1*KeyTweakBasicGlobals.stepSize1,1*KeyTweakBasicGlobals.stepSize1]);
	app.endUndoGroup();			
    };
    pal.UI.main.simple.crosses.cross1.lower.right.onClick = function(){
	app.beginUndoGroup("KeyTweak");
	keyMove([1*KeyTweakBasicGlobals.stepSize1,1*KeyTweakBasicGlobals.stepSize1]);
	app.endUndoGroup();			
    };
    pal.UI.main.simple.crosses.cross1.upper.middle.onClick = function(){
	app.beginUndoGroup("KeyTweak");
	keyMove([0,-1*KeyTweakBasicGlobals.stepSize1]);
	app.endUndoGroup();			
    };
    pal.UI.main.simple.crosses.cross1.lower.middle.onClick = function(){
	app.beginUndoGroup("KeyTweak");
	keyMove([0,1*KeyTweakBasicGlobals.stepSize1]);
	app.endUndoGroup();			
    };
    /******************************** SECOND CROSS ********************************/
pal.UI.main.simple.crosses.cross2.middle.left.onClick = function(){	
	app.beginUndoGroup("KeyTweak");
	keyMove([-1*KeyTweakBasicGlobals.stepSize2,0]);
	app.endUndoGroup();			
    };
    pal.UI.main.simple.crosses.cross2.middle.right.onClick = function(){
	app.beginUndoGroup("KeyTweak");
	keyMove([1*KeyTweakBasicGlobals.stepSize2,0]);
	app.endUndoGroup();			
    };
    pal.UI.main.simple.crosses.cross2.upper.left.onClick = function(){
	app.beginUndoGroup("KeyTweak");
	keyMove([-1*KeyTweakBasicGlobals.stepSize2,-1*KeyTweakBasicGlobals.stepSize2]);
	app.endUndoGroup();			
    };
    pal.UI.main.simple.crosses.cross2.upper.right.onClick = function(){
	app.beginUndoGroup("KeyTweak");
	keyMove([1*KeyTweakBasicGlobals.stepSize2,-1*KeyTweakBasicGlobals.stepSize2]);
	app.endUndoGroup();			
    };
    pal.UI.main.simple.crosses.cross2.lower.left.onClick = function(){
	app.beginUndoGroup("KeyTweak");
	keyMove([-1*KeyTweakBasicGlobals.stepSize2,1*KeyTweakBasicGlobals.stepSize2]);
	app.endUndoGroup();			
    };
    pal.UI.main.simple.crosses.cross2.lower.right.onClick = function(){
	app.beginUndoGroup("KeyTweak");
	keyMove([1*KeyTweakBasicGlobals.stepSize2,1*KeyTweakBasicGlobals.stepSize2]);
	app.endUndoGroup();			
    };
    pal.UI.main.simple.crosses.cross2.upper.middle.onClick = function(){
	app.beginUndoGroup("KeyTweak");
	keyMove([0,-1*KeyTweakBasicGlobals.stepSize2]);
	app.endUndoGroup();			
    };
    pal.UI.main.simple.crosses.cross2.lower.middle.onClick = function(){
	app.beginUndoGroup("KeyTweak");
	keyMove([0,1*KeyTweakBasicGlobals.stepSize2]);
	app.endUndoGroup();			
    };

	pal.UI.main.simple.buttons.selecteMaskVectices.onClick = function(){
		var comp = app.project.activeItem; 
		if (comp == null || !(comp instanceof CompItem)){ 
		    alert(loc({en:'Please select a composition.',de:'Bitte wähle eine Komposition aus.'})); 
			return false;
			}
		var selectedProps= getSelectedProperties(comp);
		if(selectedProps.length != 1) {
		    myError(loc({en:'Please select exactly exactly one mask shape or other shape property.',de:'Bitte wähle genau einen Maskenpfad oder Shape aus.'})); 
			return false;
			}
		var prop = selectedProps[0];
		if (prop.propertyValueType!=PropertyValueType.SHAPE){
		    myError(loc({en:'Please select a mask shape or other shape property that you want to modify.',de:'Bitte wähle einen Maskenpfad oder andern Shape aus, den Du modifizieren möchtest.'})); 
			return false;
			}
		
	     var visRadius = getRadius(prop.value.vertices); // radius of the points of the visualization
		 var layerName = comp.selectedLayers[0].name; // name of the layer that contains the mask
		 
		var vertexWindow= new Window("window", KeyTweakBasicGlobals.scriptName+loc({en:' - select shape vertices',de:' - Maskenpunkte auswählen'}),undefined,  {resizeable: true} );
		var vertexDlg = 
			"group{\
			orientation:'column', \
			alignment:['fill','fill'],\
			margins:0,\
			labelFirst: StaticText{text:'"+loc({en:'first vertex: ',de:'erster Punkt: '})+(KeyTweakBasicGlobals.MaskVertexFirst+1)+"', alignment:['fill','fill'],\}, \
			scrollFirst:Slider{alignment:['fill','bottom']},\
			labelNum: StaticText{text:'"+loc({en:'number of vertices: ',de:'Anzahl der Punkte: '})+(KeyTweakBasicGlobals.MaskVertexNum)+"', alignment:['fill','fill']}, \
			scrollNum:Slider{alignment:['fill','bottom']},\
			okBtn:Button{text:'OK',alignment:['center','bottom']}\
			}";
			
		vertexWindow.UI = vertexWindow.add(vertexDlg);
         vertexWindow.UI.scrollFirst.value=KeyTweakBasicGlobals.MaskVertexFirst;         
		vertexWindow.UI.scrollFirst.minvalue=0;
		vertexWindow.UI.scrollFirst.maxvalue=(prop.value).vertices.length-1;
		vertexWindow.UI.scrollNum.value=KeyTweakBasicGlobals.MaskVertexNum;
		vertexWindow.UI.scrollNum.minvalue=1;
		vertexWindow.UI.scrollNum.maxvalue=(prop.value).vertices.length;
		
		function getSelectedVertices(val,first, num){  // returns the sub-array of val from first to last if first <=last of from 0 to last and first to end, if not.
			if(first +num<= val.length) {
				return val.slice(first,first+num);
			    }
			else {
				var temp = val.slice(first,val.length);
				return temp.concat(val.slice(0,first+num-val.length));
				}
			}
		vertexWindow.UI.scrollFirst.onChange = vertexWindow.UI.scrollFirst.onChanging = function(){
			var newValue = Math.round(this.value);
			if(KeyTweakBasicGlobals.MaskVertexFirst!= newValue){
				KeyTweakBasicGlobals.MaskVertexFirst= newValue;
				vertexWindow.UI.labelFirst.text=loc({en:'first vertex: ',de:'erster Punkt: '})+(KeyTweakBasicGlobals.MaskVertexFirst+1); // show not starting from 0 but from 1
				 updateVisualizationLayer(comp,layerName,visRadius,getSelectedVertices(prop.value.vertices,KeyTweakBasicGlobals.MaskVertexFirst,KeyTweakBasicGlobals.MaskVertexNum));
				}
			}
		vertexWindow.UI.scrollNum.onChange = vertexWindow.UI.scrollNum.onChanging = function(){
			var newValue = Math.round(this.value);
			if(KeyTweakBasicGlobals.MaskVertexNum!= newValue){
				KeyTweakBasicGlobals.MaskVertexNum= newValue;
				vertexWindow.UI.labelNum.text=loc({en:'number of vertices: ',de:'Anzahl der Punkte: '})+(KeyTweakBasicGlobals.MaskVertexNum); // show not starting from 0 but from 1
				updateVisualizationLayer(comp,layerName,visRadius,getSelectedVertices(prop.value.vertices,KeyTweakBasicGlobals.MaskVertexFirst,KeyTweakBasicGlobals.MaskVertexNum));
				}
			}
		vertexWindow.onResizing = vertexWindow.onResize = function () {
			this.layout.resize();
			}
		vertexWindow.onClose = function(){
			removeVisualizationLayer(comp);
			prop.selected=true;
			}
		vertexWindow.UI.okBtn.onClick= function() {
			vertexWindow.close();
			}
		
		updateVisualizationLayer(comp,layerName,visRadius,getSelectedVertices(prop.value.vertices,KeyTweakBasicGlobals.MaskVertexFirst,KeyTweakBasicGlobals.MaskVertexNum));
		vertexWindow.show();
		};
	
    return pal;
}



/******************************************************************************
prints an error message
*********************************************************************************/
function myError(message){
    alert(message,KeyTweakBasicGlobals.scriptName+": Error");
}


/******************************************************************************
Localize a localization object to the choosen language
*********************************************************************************/
function loc(obj){
	if(KeyTweakBasicGlobals.language != "auto"){
			$.locale=KeyTweakBasicGlobals.language;
			var localString =localize(obj);	
			$.locale=null; // restore to the locale of the host app
			return localString;
			}
	else {
		return localize(obj);
		}
	}

/******************************************************************************
returns the current version of the script returned by the aescripts server
*********************************************************************************/
function GetVersion(scriptname){ // eg expression-toolbox
	
   var url = "notify.aescripts.com/versioncheck.php?name=" + scriptname; 
   var port=80;
   var domain=url.split("/")[0]+":"+port;
   var fileName=url.substr(url.lastIndexOf("/")+1);
   var call="GET ";
   if(url.indexOf("/")<0){
      call+="/";
   }else{
      call+=url.substr(url.indexOf("/"));
   }
   call+=" HTTP/1.1\n";
   call+="Host: "+domain+"\n\n";
   call+="Connection: close\n\n";

   var reply = new String();
   var file = new File();
   file.encoding = "binary";
   file.open("w");
   var conn = new Socket();
   conn.encoding = "binary";
   if (conn.open (domain, "binary")) {
       conn.write (call);

		//Read enough to get the headers
		reply = conn.read(300);

		//parse content length out of the header
		var contentLengthHeader = String(reply.match(/Content-Length: [0-9]*/));
		var contentLength = contentLengthHeader.substr (16);
		
		//parse for header length
		var headerLength = reply.indexOf("\n\n")+2;

		//read the rest of the message (content + header - what we have already read)
		reply += conn.read(contentLength + headerLength - 300);
		var recievedVersion = reply.toString().substring(reply.toString().lastIndexOf("BeginVersion")+12,reply.toString().lastIndexOf("EndVersion"));
		
		conn.close();
   }else{
      reply = "";
   }

  return recievedVersion; 
}
/******************************************************************************
if silent, a message is only generated, if updates are available and not
if server is not available or if the version is the current one
*********************************************************************************/
function checkUpdates(silent){
	checkUpdatesGeneric(silent,KeyTweakBasicGlobals);
	}
function checkUpdatesGeneric(silent,myGlobals){
////////////////////////////////
// if silent then only check at most every 10 days...
if(silent){
	var checkTime = new Date();
	var timeCheck = parseFloat(checkTime.getTime() / 1000);
	var lastCheck =  0;
	if (app.settings.haveSetting(myGlobals.settingsSection, "lastUpdateCheck"))  {
		lastCheck = parseFloat(app.settings.getSetting(myGlobals.settingsSection, "lastUpdateCheck").toString());
		}
	if((timeCheck - lastCheck) / 86400 > 10){ //check every 10 days at most
		app.settings.saveSetting(myGlobals.settingsSection, "lastUpdateCheck", timeCheck);
		}
	else {	
		return;  // do not check, since last update was less thatn 10 days ago
		}
	}
///////////////////////////////////

try{
	var mostRecent = parseFloat( GetVersion(myGlobals.scriptURLName) ); 
	}
catch(e){
	if(!silent) {myError(loc({en:'There was an error connecting to the update server, please try again. Make sure that you have "Allow Scripts to Write Files and Access Network" enabled in your AE Preferences (Edit->Preferences->General).',
									 de:'Konnte keine Verbindung zum Update-Server herstellen. Achte darauf, dass Du die Option "Skripten können Dateien schreiben und haben Netzwerkzugang" unter Bearbeiten->Voreinstellungen->Allgemein aktiviert hast.'}) ); }
	return;
	}

if( !isNaN(mostRecent) )
	{
	if(  mostRecent > parseFloat ( myGlobals.scriptVersionNumber.toString() )  ) { 
		alert(loc({en:'A new version of '+myGlobals.scriptName +' is available.\nYou can download it at http://www.mamoworld.com'
						+'\nyour version: '+myGlobals.scriptVersionNumber.toString() +'\nnew version: '+mostRecent,
					de:'Eine neue Version von '+myGlobals.scriptName +' ist verfügbar.\nDu kannst sie auf http://www.mamoworld.com herunterladen.'
						+'\nDeine Version: '+myGlobals.scriptVersionNumber.toString() +'\nNeue Version: '+mostRecent}));
		} 
	else { 
		if(!silent){
			alert(loc({en:'There is no newer version available.',de:'Es ist keine neuen Versionen verfügbar.'})); 
			}
		} 
	} 
else { 
	if(!silent) {
		myError (loc({en:'There was an error connecting to the update server, please try again.',de:'Konnte keine Verbindung zum Update-Server herstellen.'}));
		} 
	} 
}

/********************************************************************************************
Returns an Array with all Property-Objects selected in the comp (selected 
PropertyGroup-Objects are not included)
**********************************************************************************************/
function getSelectedProperties(comp){
    var i=0;
    var properties= new Array();
    for(i=0;i<comp.selectedProperties.length;i++){
		if(comp.selectedProperties[i].constructor.name=="Property"){ // we have a property and no property group
			properties[properties.length]=comp.selectedProperties[i];
		}	
    }
    return properties;
}

/*****************************************************
computes the radius for the visualization points 
*****************************************************/
function getRadius(points){
var radius =KeyTweakBasicGlobals.circleEffectRadius;
// shorten the radius if necessary
for(i=0;i<points.length-1;i++){
	for(j=i+1;j<points.length;j++){
		var dx=points[i][0]-points[j][0];
		var dy=points[i][1]-points[j][1];
		var dist = Math.sqrt(dx*dx+dy*dy);
		radius = Math.min(radius,dist*KeyTweakBasicGlobals.circleEffectRadiusSpacingFactor);
		}
	}
return radius;
}


/****************************************************
generateVisualizationLayer(colors);
****************************************************/
/* generates the visualization layer in the comp if it does not exist yet and
	updates/generates the  circle effects for each of the 2d points given in the Array points  

layername gives the name of the layer in which the given point coordinates live. Via expressions the coordinates are
automatically transformed from this local layer coordinate system to the coordinate system of the visualization layer
*/
function updateVisualizationLayer(comp, layerName,radius,points){

// store a copy of the selected properties to restore it later
var selectedProperties = new Array;
for(var i=0;i< comp.selectedProperties.length;i++){
	selectedProperties[i]=comp.selectedProperties[i];
	}


var layer =comp.layers.byName(KeyTweakBasicGlobals.visualizationLayerName); 
if(layer== null){
	layer= comp.layers.addSolid([1.0,1.0,0], KeyTweakBasicGlobals.visualizationLayerName, comp.width, comp.height,comp.pixelAspect,comp.duration);	
	layer.adjustmentLayer=true;
	}

var effects = layer("Effects"); 
// delete all effects
while(effects.numProperties>0){
	effects.property(1).remove();
	}

// add new effects
for(i=0;i<points.length;i++){
	if(!effects.canAddProperty("ADBE Circle")){
	    myError(loc({en:'Cannot create a Color Control Effect on layer ',de:'Kann keinen Color Control Effekt erzeugen auf der Ebene '})+layer.name+"!");
		return false;
		}
	effect=effects.addProperty("ADBE Circle");
	if (effect == null){
	    myError(loc({en:'Failed creating circle effect on visualization layer.',de:'Erzeugung der Visualisierungsebene fehlgeschlagen!'}));
		return false;
		}
	effect.name=KeyTweakBasicGlobals.circleEffectNamePrefix+i;
	
	var myRadius = radius;
	if(i==0){ myRadius *= KeyTweakBasicGlobals.circleEffectRadiusScaleFirst;}
	
	var myExpression="thisComp.layer(\""+layerName+ "\").toComp(["+ points[i][0]+","+points[i][1] +"])";
	effect.property("ADBE Circle-0001").expression=myExpression;// center
	effect.property("ADBE Circle-0002").setValue(myRadius);	// radius
	effect.property("ADBE Circle-0006").setValue(0);	// weiche Kante aussen
	effect.property("ADBE Circle-0010").setValue(KeyTweakBasicGlobals.circleEffectColor);	// color
	effect.property("ADBE Circle-0011").setValue(KeyTweakBasicGlobals.circleEffectTransparency);	// transparency
	effect.property("ADBE Circle-0012").setValue(2);	// Füllmethode auf normal setzen
     effect.selected=false;
	}

layer.selected=false;
for(var i=0;i< selectedProperties.length;i++){
	selectedProperties[i].selected=true;
	}

 
return true;
}
/*******************************************************************************
removeVisualizationLayer(comp)
deletes the visualizataion layer if it exists
**********************************************************************************/
function removeVisualizationLayer(comp){
var layer =comp.layers.byName(KeyTweakBasicGlobals.visualizationLayerName); 
if(layer!= null){
	layer.remove();
	}
}

/*******************************************************************************
gets called when any of the arrow buttons is pressed
move is a 2d-value that represents the number of pixels to move
i.e. number in the middle of the arrow buttons
**********************************************************************************/
function keyMove(move){
    var comp = app.project.activeItem; 
    if (comp == null || !(comp instanceof CompItem)){ 
	alert(loc({en:'Please select a composition.',de:'Bitte wähle eine Komposition aus'})); 
		return false;
    }
    var selectedProps= getSelectedProperties(comp);
for(var i= 0; i< selectedProps.length;i++){
	keyMoveProp(move,selectedProps[i]);
	}
}
function keyMoveProp(move,prop){
	 var comp = app.project.activeItem; 
    if (comp == null || !(comp instanceof CompItem)){ 
	alert(loc({en:'Please select a composition.',de:'Bitte wähle eine Komposition aus'})); 
		return false;
    }
    if ((prop.propertyValueType!=PropertyValueType.TwoD_SPATIAL) && 
		(prop.propertyValueType!=PropertyValueType.TwoD) &&
		(prop.propertyValueType!=PropertyValueType.ThreeD_SPATIAL) &&
		(prop.propertyValueType!=PropertyValueType.ThreeD) &&
		(prop.propertyValueType!=PropertyValueType.SHAPE)){
	myError(loc({en:'Please select some 2d property, 3d property, mask shape or other shape.\n\n'+
			'Tip: If you need to tweak keypframes of other properties (like 1D properties), '+
			'use the functions of the global mode.',
			de:'Bitte wähle eine 2d oder 3d Eigenschaft oder einen Maskenpfad oder einen Shapepfad aus.\n\n'+
			'Tip: Wenn Du eine andere Eigenschaft mit KeyTweak bearbeiten möchtest (etwa eine 1D Eigenschaft), '+
			' benutze dazu die Funktionen des globales Modus'})); 
	return false;
    }
    
if((prop.propertyValueType==PropertyValueType.ThreeD_SPATIAL) ||
   (prop.propertyValueType!=PropertyValueType.ThreeD) ){
	   move[2]=0; // add a third dimension;
	   }

var currentTime =comp.layers[1].time;

if(KeyTweakBasicGlobals.selectedMode == KeyTweakBasicGlobals.ModeCurrentFrame){
	moveAtTime(prop,currentTime,move);
    }
else{ // any of the functions that acts on the entire workarea
    if(prop.numKeys < 1) {
	myError(loc({en:'The selected property has no keyframes to modify.',
			de:'Die selektierte Eigenschaft hat keine Keyframes die bearbeitet werden könnten.'}));
	return false;
    }		
  
    var firstKey = prop.nearestKeyIndex(comp.workAreaStart);
    var lastKey = prop.nearestKeyIndex(comp.workAreaStart+ comp.workAreaDuration);
    if(prop.keyTime(firstKey) < comp.workAreaStart) { firstKey++;}
    if(prop.keyTime(lastKey) > comp.workAreaStart+comp.workAreaDuration) { lastKey--; }
    var numKeys= lastKey- firstKey + 1;
    
    if(numKeys < 1) {
	myError(loc({en:'There are  no keyframes in the current workarea to modify.',
			de:'Der aktuelle Arbeitsbereich enthält keine Keyframes die bearbeitet werden könnten.'}));
	return false;
    }		
    
	for(var i=0;i<numKeys;i++){
		var time = prop.keyTime(firstKey+i);
		var scale =1;
		if(time < currentTime && 
			((KeyTweakBasicGlobals.selectedMode == KeyTweakBasicGlobals.ModeWorkareaFadeIn) ||
			(KeyTweakBasicGlobals.selectedMode == KeyTweakBasicGlobals.ModeWorkareaFade))){
			scale = (time - comp.workAreaStart)/(currentTime - comp.workAreaStart);
			//debug +="if ";
			}
		else if(time > currentTime &&
			((KeyTweakBasicGlobals.selectedMode == KeyTweakBasicGlobals.ModeWorkareaFadeOut) ||
			(KeyTweakBasicGlobals.selectedMode == KeyTweakBasicGlobals.ModeWorkareaFade))){
			scale = 1- ((time - currentTime)/(comp.workAreaStart+comp.workAreaDuration-currentTime));
			debug +="el ";
			}
		
		var thisMove = new Array;
		for( var j=0; j<move.length; j++){thisMove[j]=move[j]*scale;}
		moveAtTime(prop,time,thisMove);
		}
	}
return true;
}

/******************************************************************************************
adds the value "move" to the value of the property "prop" at time point "time"
If property is a shape, only the selected points are moved
*************************************************************************************************/
function moveAtTime(prop,time,move){
	var value =prop.valueAtTime(time,true);
		
	if (prop.propertyValueType!=PropertyValueType.SHAPE){
		value=propAdd(value,move,prop.propertyValueType);	
		}
	else{ // Mask --> only move selected vertices, not all
		var vertices = new Array;
		var inTan = new Array;	
		var outTan = new Array;	
		for(var i=0;i<value.vertices.length;i++){ 
			var pt = value.vertices[i];
			var iTan = value.inTangents[i];
			var oTan = value.outTangents[i];
			if(
			    ((i>=KeyTweakBasicGlobals.MaskVertexFirst) && (i<= KeyTweakBasicGlobals.MaskVertexFirst +KeyTweakBasicGlobals.MaskVertexNum-1))
				||
				 (i<=KeyTweakBasicGlobals.MaskVertexFirst +KeyTweakBasicGlobals.MaskVertexNum-value.vertices.length-1)
				 ){
				pt[0] +=move[0];
				pt[1] +=move[1];
				}
			vertices[i]=pt;
			inTan[i]=iTan;
			outTan[i]=oTan;
			}
		value.vertices=vertices;
		value.inTangents=inTan;
		value.outTangents=outTan;
		}
	prop.setValueAtTime(time,value);	
	}


/**********************************************************************************************
gets called when keyTweak button is pressed
***********************************************************************************************/
function keyTweak(){
    var comp = app.project.activeItem; 
    if (comp == null || !(comp instanceof CompItem)){ 
	alert("Please select a composition"); 
	return false;
    }
    
    // check whether valid properties are selected
    var selectedProps= getSelectedProperties(comp);
    if(selectedProps.length != 2) {
	myError(loc({en:'Select exactly two properties (i.e. the original property and its modified copy).',
			de:'Wähle genau zwei Eigenschaften aus (die Original-Eigenschaft und die modifizierte Kopie)'})); 
	return;
    }
    if(selectedProps[0].propertyValueType != selectedProps[1].propertyValueType) {
	myError(loc({en:'The two selected properties are not of the same value type.',de:'Die zwei ausgewählten Eigenschaften haben nicht den gleichen Typ.'})); 
	return;
    }
    if((selectedProps[0].numKeys < 1) || (selectedProps[1].numKeys < 1)) {
	myError(loc({en:'The selected properties must have at least one keyframe.',
			de:'Die ausgewählten Eigenschaften müssen mindestens einen Keyframe haben.'}));
	return;
    }
    if(    selectedProps[0].propertyValueType==PropertyValueType.SHAPE 
	   && (selectedProps[0].value.vertices.length != selectedProps[1].value.vertices.length)){
	myError(loc({en:'The two selected mask shapes must have the same number of vertices. \n'+
			'If you need to introduce new mask vertices introduce them into the original mask before creating the duplicate.',
			de:'Die zwei ausgewählten Maskenpfade müssen die gleiche Anzahl von Punkten haben.\n'+
			'Wenn Du neue Punkte in den Maskenpfad einfügen möchtest, füge die Punkte in das Original ein bevor Du die Kopie erzeugst.'
			}));
	return;
	}
    
    // original is the property with the many keyframes that are adjusted by the script
    var original= (selectedProps[0].numKeys > selectedProps[1].numKeys) ? selectedProps[0] : selectedProps[1];
    // modified is the copy of original that contains less (i.e. the manually modified) keyframes
    var modified = (selectedProps[0].numKeys > selectedProps[1].numKeys) ? selectedProps[1] : selectedProps[0];
    
    var next =1;  // the next keyframe of original that is computed
    var last = original.numKeys; // the last keyframe of  original that is computed
    if(KeyTweakBasicGlobals.onlyWorkarea){
	var firstOriginal = original.nearestKeyIndex(comp.workAreaStart);
	var firstModified = modified.nearestKeyIndex(comp.workAreaStart);
	var lastOriginal =  original.nearestKeyIndex(comp.workAreaStart+ comp.workAreaDuration);
	var lastModified = modified.nearestKeyIndex(comp.workAreaStart+ comp.workAreaDuration);
	if(original.keyTime(firstOriginal) < comp.workAreaStart) { firstOriginal++;}
	if(modified.keyTime(firstModified) < comp.workAreaStart) { firstModified++;}
	if(original.keyTime(lastOriginal) > comp.workAreaStart+comp.WorkAreaDuration) { lastOriginal--;}
	if(modified.keyTime(lastModified) > comp.workAreaStart+comp.WorkAreaDuration) { lastModified--;}
	
	var numKeysOriginal= lastOriginal- firstOriginal + 1;
	var numKeysModified= lastModified- firstModified + 1;
	if(numKeysOriginal < 1 || numKeysModified < 1) {
	    myError(loc({en:'The selected properties must have at least one keyframe in the work Area if \'workarea only\' option is chosen.',
			    de:'Die ausgeählten Eigenschaften müssen mindestens einen Keyframe im Arbeitsbereich haben, wenn die Option \'nur Arbeitsbereich\' ausgewählt ist.'}));
	    return;
	}
	if(numKeysOriginal < numKeysModified) { // in the workarea, the original has less keyframes -> swap roles
	    var temp = original;
	    original = modified;
	    modified = temp;
	    next = firstModified;
	    last = lastModified;
	}
	else {
	    next = firstOriginal;
	    last = lastOriginal;
	}
    }
    // initialize the progress bar
    KeyTweakBasicGlobals.progress.value= 0;
    KeyTweakBasicGlobals.progress.maxvalue=last - next +1;

    next= tweakKeysBeforeFirst(original,modified,next,last);
    
    var i=modified.nearestKeyIndex(modified.keyTime(1));
    while( i<modified.numKeys){  // key indices are counted from 1!?!
	var next_i_time = modified.keyTime(i+1);
	next= tweakKeysBetween(i,i+1,original,modified,next,last);
	i = modified.nearestKeyIndex(next_i_time); // tweakKeysBetween might introduce new keyframes in modified, therefore reconstruct i from its time
    }
    tweakKeysAfterLast(original,modified,next,last);
    
    writeLn("KeyTweak: processed "+ KeyTweakBasicGlobals.progress.value + " keyframes");
    KeyTweakBasicGlobals.progress.value= 0; // computation done, set progress bar back to 0
}

/********************************************************************************
tweaks all keys k of original that are before the first keyframe of modified
********************************************************************************/
function tweakKeysBeforeFirst(original,modified,next,last){
    var time = modified.keyTime(1);
    var move = modified.valueAtTime(time,false);
    move=propSubtract(move,original.valueAtTime(time,false),modified.propertyValueType);
    
    var i=next;
    while(i <= last && original.keyTime(i) < time){
	var value= original.keyValue(i);
	value=propAdd(value,move,original.propertyValueType);
	if(KeyTweakBasicGlobals.writeOriginal){ original.setValueAtKey(i,value);}
	else					     {modified.setValueAtTime(original.keyTime(i),value);}
	KeyTweakBasicGlobals.progress.value++;
	i++;
	}
    return i;
}

/**********************************************************************************
tweaks all keys k of original  with i<=k<j, where i and j are keys of modified
***********************************************************************************/
function tweakKeysBetween(i,j,original,modified,next,last){
    var vt=original.propertyValueType;
    var time0 = modified.keyTime(i);
    var time1 = modified.keyTime(j);
    var move0 = modified.valueAtTime(time0,false);
    move0=propSubtract(move0,original.valueAtTime(time0,false),vt);
    
    var move1 =modified.valueAtTime(time1,false) 
	move1=propSubtract(move1,original.valueAtTime(time1,false),vt);
    
    var i=next;
    while(i <= last && original.keyTime(i) < time1){
	var weight1=(original.keyTime(i)-time0)/(time1-time0);
	var weight0=1-weight1;
	var value= original.keyValue(i);
	value=propAddFactored (value,move0,weight0, vt);
	value=propAddFactored (value,move1,weight1, vt);
	if(KeyTweakBasicGlobals.writeOriginal){ original.setValueAtKey(i,value);}
	else{modified.setValueAtTime(original.keyTime(i),value);}
	KeyTweakBasicGlobals.progress.value++;
	i++;
    }
    return i;
}

/********************************************************************************
tweaks all keys of original behind the last key of modified
********************************************************************************/
function tweakKeysAfterLast(original,modified,next,last){
    var time = modified.keyTime(modified.numKeys);
    var move = modified.valueAtTime(time,false);
    move=propSubtract(move,original.valueAtTime(time,false),modified.propertyValueType);
    
    var i=next;
    while(i <= last){
	var value= original.keyValue(i);
	value=propAdd(value,move,original.propertyValueType);
	if(KeyTweakBasicGlobals.writeOriginal){ original.setValueAtKey(i,value);}
	else{modified.setValueAtTime(original.keyTime(i),value);}
	KeyTweakBasicGlobals.progress.value++;
	i++;
    }
    return i;
}
/*******************************************************************************
	computes := p1 + (k*p2) 
	for k being a number and p1,p2 being properties of type "type"
********************************************************************************/
function propAddFactored(p1,p2,k,type){
    switch(type){
    case PropertyValueType.ThreeD_SPATIAL:
    case PropertyValueType.ThreeD:
    case PropertyValueType.TwoD_SPATIAL:
    case PropertyValueType.TwoD:
    case PropertyValueType.Color:
	for(var i=0;i<p1.length;i++) { p1[i]+=k*p2[i];}
	break;
	case PropertyValueType.OneD:
		p1+=k*p2;
	break;
    case PropertyValueType.SHAPE:
	var vertices = new Array;
	var inTan = new Array;
	var outTan = new Array;
	for(var i=0;i<p1.vertices.length;i++){ 
	    var pt = p1.vertices[i];
	    pt[0] += k* p2.vertices[i][0];
	    pt[1] += k* p2.vertices[i][1];
	    vertices[i]=pt;
	    inTan[i] = p1.inTangents[i];
	    outTan[i]=p1.outTangents[i];
	}
	p1.vertices=vertices;
	p1.inTangents=inTan;
	p1.outTangents=outTan;
	break;
    default:
	myError("unsupported property value type.");
    }
return p1;
}


/*********************************************************************************
	computes p1:=p1-p2  for p1 and p2 being properties of type "type"
**********************************************************************************/
function propSubtract(p1,p2,type){
    return propAddFactored (p1, p2, -1, type);
}
/*********************************************************************************
	computes p1:=p1+p2  for p1 and p2 being properties of type "type"
**********************************************************************************/
function propAdd(p1,p2,type){
    return propAddFactored (p1, p2, 1, type);
}

///////////////////////////////////// checkEULA
// returns true, if the Enduser License Agreement (EULA) was accepted by the user (in this or a previous session)
function checkEula(myGlobals){
 
var eulaAccepted= app.settings.haveSetting(myGlobals.settingsSection,"eulaAccepted") ?
	(app.settings.getSetting(myGlobals.settingsSection,"eulaAccepted")):(false);

if(eulaAccepted){return true;}

var eulaWindow= new Window("dialog", myGlobals.scriptName+loc({en:' License Agreement',de:' Lizenzbestimmungen'}),undefined,  {resizeable: true} );
 var eulaDlg = 
			"group{\
			orientation:'column', \
			alignment:['fill','fill'],\
			preferredSize:[400,200],\
			margins:0,\
			eulabox:EditText{properties:{multiline:true, readonly:true},text:'',preferredSize:[-1,60],alignment:['fill','fill']},\
			agree:Checkbox{text:'"+loc({en:'I accept the licence agreement.',de:'Ich akzeptiere die Lizenzbestimmungen.'})+"', value:false,alignment:['left','bottom']},\
			buttonsGrp:Group{ alignment:['center','bottom']\
				okBtn:Button{text:'OK',alignment:['center','bottom'],enabled:false},\
				cancelBtn:Button{text:'"+loc({en:'Cancel',de:'Abbrechen'})+"',alignment:['center','bottom']}\
				}\
			}";
eulaWindow.UI = eulaWindow.add(eulaDlg);
eulaWindow.UI.agree.onClick=function(){eulaWindow.UI.buttonsGrp.okBtn.enabled = eulaWindow.UI.agree.value;};           
eulaWindow.UI.buttonsGrp.okBtn.onClick = function() {eulaAccepted =eulaWindow.UI.agree.value; eulaWindow.close(); };
eulaWindow.UI.buttonsGrp.cancelBtn.onClick = function() {eulaWindow.close(); };
eulaWindow.UI.eulabox.text=myGlobals.eula;
eulaWindow.onResizing = eulaWindow.onResize = function () {
this.layout.resize();
}
eulaWindow.show();
 
if(eulaAccepted){
	 app.settings.saveSetting(myGlobals.settingsSection,"eulaAccepted",true);
	 }
return eulaAccepted;
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// MAIN
/// build the user interface


if(typeof KeyTweakBasicGlobals.severeFail=='undefined' &&  // no major problem during startup
     checkEula(KeyTweakBasicGlobals)  // user accepted Eula
	 ){ 
  var userinterface = buildUI(this);
  if ((userinterface != null) && (userinterface instanceof Window))
  userinterface.show();
  }
}



